use collapse-state-emp-month.dta, clear
gen type=1 if ageg==1 | ageg==2
replace type=2 if ageg==3 & (ed==1 | ed==2) & sex==1
replace type=3 if ageg==3 & (ed==1 | ed==2) & sex==2
replace type=4 if ageg==3 & (ed==3 | ed==4) & sex==1
replace type=5 if ageg==3 & (ed==3 | ed==4) & sex==2
replace type=6 if ageg==4 

sort type year month
replace lfpr=lfpr*n
collapse (sum) lfpr n, by(type year month)
replace lfpr=lfpr/n
drop n

reshape wide lfpr, i(year month) j(type)
sort year month
tempfile temp
save `temp', replace

use collapse-state-emp-month.dta, clear
gen type=7 if ageg==3 & (ed==1 | ed==2) 
replace type=8 if ageg==3 & (ed==3 | ed==4) 
drop if type==.

sort type year month
replace lfpr=lfpr*n
collapse (sum) lfpr n, by(type year month)
replace lfpr=lfpr/n
drop n

reshape wide lfpr, i(year month) j(type)
sort year month
tempfile temp2
save `temp2', replace

use `temp', clear
sort year month
merge year month using `temp2'
drop _merge

rename lfpr1 lfpr_1624
rename lfpr2 lfpr_prime_lessed_m
rename lfpr3 lfpr_prime_lessed_f
rename lfpr4 lfpr_prime_moreed_m
rename lfpr5 lfpr_prime_moreed_f
rename lfpr6 lfpr_55p
rename lfpr7 lfpr_prime_lessed
rename lfpr8 lfpr_prime_moreed

save lfpr-series-nsa.dta, replace
